
<?php $__env->startSection('title'); ?>
     - Batch
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainPart'); ?>
    <main class="ttr-wrapper">
        <div class="container-fluid">
            <?php if(Session::has('message')): ?>
                <div class="notification"><div class="alert alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(Session::get('message')); ?></div></div>
            <?php endif; ?>
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <div class="db-breadcrumb">
                <h4 class="breadcrumb-title">Batch</h4>
                <ul class="db-breadcrumb-list">
                    <li><a href="<?php echo e(route('admin.dashboard')); ?>"><i class="fa fa-home"></i>Home</a></li>
                    <li>Batches</li>
                </ul>
            </div>
            <div class="row">
                <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-12">
                    <button class="btn bg-success mb-2" data-toggle="modal" data-target="#addBatch" style="color:white;">Add New Batch</button>
                    <table class="table table-hover table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Duration</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $batches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(++$key); ?></td>
                                <td><?php echo e($batch->name); ?></td>
                                <td><?php if( $batch->status==1 ): ?><span class="badge badge-success">Active</span>
                                    <?php elseif( $batch->status==0 ): ?><span class="badge badge-danger">Inactive</span>
                                    <?php endif; ?>
                                <td>
                                    <a href="#" data-toggle="modal" data-target="#statusModal<?php echo e($batch->id); ?>" class="mr-2" title="Change Status!"><i class="fa fa-refresh text-warning"></i></a>
                                    <a href="#" class="mr-2" title="Edit" data-toggle="modal" data-target="#editModal<?php echo e($batch->id); ?>" ><i class="fa fa-edit text-info"></i></a>
                                    <a href="#" title="Delete" data-toggle="modal" data-target="#deleteModal<?php echo e($batch->id); ?>" ><i class="fa fa-trash text-danger"></i></a>
                                </td>
                                <!-- Edit Modal -->
                                <div class="modal fade" id="editModal<?php echo e($batch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Edit Batch</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form method="post" action="<?php echo e(route('admin.batch.update')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <label for="CourseName">Batch Name</label>
                                                    <input type="hidden" class="form-control" name="id" value="<?php echo e($batch->id); ?>">
                                                    <input type="text" class="form-control" name="name" value="<?php echo e($batch->name); ?>">
                                                    <?php if ($errors->has('name')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('name'); ?>
                                                        <span style="color:red;"><b><?php echo e($message); ?></b></span>
                                                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                </div>
                                                <div class="form-group">
                                                    <label for="Status">Status</label>
                                                    <select class="form-control" id="Status" name="status">
                                                        <?php if($batch->status==1): ?>
                                                            <option value="1">Active</option>
                                                            <option value="0">Inactive</option>
                                                        <?php elseif($batch->status==0): ?>
                                                            <option value="0">Inactive</option>
                                                            <option value="1">Active</option>
                                                        <?php endif; ?>
                                                    </select>
                                                    <?php if ($errors->has('status')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('status'); ?>
                                                        <span style="color:red;"><b><?php echo e($message); ?></b></span>
                                                    <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-primary">Update changes</button>
                                            </div>
                                        </form>
                                        </div>
                                    </div>
                                </div> 
                                <!-- Status Modal -->
                                <div class="modal fade" id="statusModal<?php echo e($batch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Change Status!</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form method="post" action="<?php echo e(route('admin.batch.status')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-body">
                                                <input type="hidden" name="id" value="<?php echo e($batch->id); ?>" />
                                                <center><span class="h3 text-danger">Are you Sure ?</span></center>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-danger bg-danger">Change</button>
                                            </div>
                                        </form>
                                        </div>
                                    </div>
                                </div>
                                <!-- Delete Modal -->
                                <div class="modal fade" id="deleteModal<?php echo e($batch->id); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog" role="document">
                                        <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel">Delete?</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form method="post" action="<?php echo e(route('admin.batch.destroy')); ?>">
                                            <?php echo csrf_field(); ?>
                                            <div class="modal-body">
                                                <input type="hidden" name="id" value="<?php echo e($batch->id); ?>" />
                                                <center><span class="h3 text-danger">Are you Sure ?</span></center>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-danger bg-danger">Delete</button>
                                            </div>
                                        </form>
                                        </div>
                                    </div>
                                </div>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>
    <!-- Modal -->
    <div class="modal fade" id="addBatch" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form method="post" action="<?php echo e(route('admin.batch.store')); ?>">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="CourseName">Batch Name</label>
                        <input type="text" class="form-control" name="name" placeholder="Enter Batch Name">
                        <?php if ($errors->has('name')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('name'); ?>
                            <span style="color:red;"><b><?php echo e($message); ?></b></span>
                        <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                    </div>
                    <div class="form-group">
                        <label for="Status">Status</label>
                        <select class="form-control" name="status">
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </select>
                        <?php if ($errors->has('status')) :
if (isset($message)) { $messageCache = $message; }
$message = $errors->first('status'); ?>
                            <span style="color:red;"><b><?php echo e($message); ?></b></span>
                        <?php unset($message);
if (isset($messageCache)) { $message = $messageCache; }
endif; ?>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary"> Save </button>
                </div>
            </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.backend.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/sohagcom/rps/resources/views/author/batch.blade.php ENDPATH**/ ?>