<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'HomeController@index')->name('home');
// Route::get('/foo', function(){
//     Artisan::call('storage:link');
//     // return Artisan::call('composer:install');
//     echo "success";
// });

Route::get('admission', 'AdmissionController@index')->name('admission.index');
//==========================Result Publish Routes=================================
Route::get('result_publish', 'ResultPublishController@index')->name('result_publish.index');
Route::post('result_publish/store', 'ResultPublishController@store')->name('result_publish.store');


Route::post('admission/store', 'AdmissionController@store')->name('admission.store');
Route::post('/branch_register', 'Author\BranchRegisterController@store')->name('branch_register.store');

Auth::routes();
/*
|--------------------------------------------------------------------------
| 					Admin Routes
|--------------------------------------------------------------------------
*/
Route::group(['as'=>'admin.','prefix'=>'admin','namespace'=>'Admin','middleware'=>['auth','admin']], function(){

	Route::get('/dashboard', 'DashboardController@index')->name('dashboard');
	//==========================Admission Routes=================================
	Route::get('admission', 'AdmissionController@index')->name('admission.index');
	Route::post('admission/approve', 'AdmissionController@approve')->name('admission.approve');
	Route::post('admission/destroy', 'AdmissionController@destroy')->name('admission.destroy');
	//==========================Course Routes=================================
	Route::get('course', 'CourseController@index')->name('course.index');
	Route::post('course/store', 'CourseController@store')->name('course.store');
	Route::post('course/status', 'CourseController@status')->name('course.status');
	Route::post('course/update', 'CourseController@update')->name('course.update');
	Route::post('course/destroy', 'CourseController@destroy')->name('course.destroy');
	//==========================Batch Routes=================================
	Route::get('batch', 'BatchController@index')->name('batch.index');
	Route::post('batch/store', 'BatchController@store')->name('batch.store');
	Route::post('batch/status', 'BatchController@status')->name('batch.status');
	Route::post('batch/update', 'BatchController@update')->name('batch.update');
	Route::post('batch/destroy', 'BatchController@destroy')->name('batch.destroy');
	//==========================Branch Routes=================================
	Route::get('branch', 'BranchController@index')->name('branch.index');
	Route::post('branch/view', 'BranchController@view')->name('branch.view');
	Route::post('branch/approve', 'BranchController@approve')->name('branch.approve');
	Route::post('branch/update', 'BranchController@update')->name('branch.update');
	Route::post('branch/passwordUpdate', 'BranchController@passwordUpdate')->name('branch.passwordUpdate');
	Route::post('branch/destroy', 'BranchController@destroy')->name('branch.destroy');
	//==========================Result Routes=================================
	Route::get('result', 'ResultController@index')->name('result.index');
	Route::get('result/branches_id', 'ResultController@branches_id')->name('result.branches_id');
	Route::get('result/courses_id', 'ResultController@courses_id')->name('result.courses_id');
	Route::post('result/store', 'ResultController@store')->name('result.store');
	Route::get('result/show', 'ResultController@show')->name('result.show');
	Route::post('result/approve', 'ResultController@approve')->name('result.approve');
	Route::post('result/view', 'ResultController@view')->name('result.view');
	Route::post('result/destroy', 'ResultController@destroy')->name('result.destroy');

});
/*
|--------------------------------------------------------------------------
| 					Author Routes
|--------------------------------------------------------------------------
*/
Route::group(['as'=>'author.','prefix'=>'author','namespace'=>'Author','middleware'=>['auth','author']], function(){
	Route::get('/dashboard', 'DashboardController@index')->name('dashboard');

	//==========================Result Routes=================================
	Route::get('result', 'ResultController@index')->name('result.index');
	Route::get('result/branches_id', 'ResultController@branches_id')->name('result.branches_id');
	Route::get('result/courses_id', 'ResultController@courses_id')->name('result.courses_id');
	Route::post('result/store', 'ResultController@store')->name('result.store');
	Route::get('result/show', 'ResultController@show')->name('result.show');
	Route::post('result/view', 'ResultController@view')->name('result.view');
	Route::post('result/destroy', 'ResultController@destroy')->name('result.destroy');
	//==========================Profle settings routes========================
	Route::post('branch/update', 'BranchController@update')->name('branch.update');
	Route::post('branch/passwordUpdate', 'BranchController@passwordUpdate')->name('branch.passwordUpdate');
	//==========================Batch Routes=================================
	Route::get('batch', 'BatchController@index')->name('batch.index');
	Route::post('batch/store', 'BatchController@store')->name('batch.store');
	Route::post('batch/status', 'BatchController@status')->name('batch.status');
	Route::post('batch/update', 'BatchController@update')->name('batch.update');
	Route::post('batch/destroy', 'BatchController@destroy')->name('batch.destroy');

});
