@extends('layouts.frontend.master')
@section('title')
  Result | Sohag Computer Training Center
@endsection
@section('content')
<div class="container">
    <div class="card">
        <div class="card-header"><img src="{{ url('assets/banner.jpg')}}" width="100%" class="rounded" height="200" style="margin-top:20px;"></div>
        <div class="card-body">
          <form action="{{ route('result_publish.store')}}" method="POST">
            @csrf
            <div class="card">
              <hr>
              <div class="card-header">
                <h3 class="text-center"> Get Your Result </h3>
              </div>
              <hr><hr>
              <div class="card-body">
                <div class="row">
                  <div class="col-md-2"></div>
                  <div class="col-md-4">
                    <h4> Course Name</h4>
                  </div>
                  <div class="col-md-1">:</div>
                  <div class="col-md-4">
                    <select name="courses_id" class="form-control" >
                      <option> Select Course </option>
                      @foreach ($courses as $key => $course)
                        <option value="{{ $course->id}}" {{ (collect(old('courses_id'))->contains($course->id)) ? 'selected':'' }}> {{ $course->name}} </option>
                      @endforeach
                    </select>
                    @error('courses_id')
                        <span style="color:red;"><b>{{ $message }}</b></span>
                    @enderror
                  </div>
                  <div class="col-md-1"></div>
                </div>
                <hr>
                <div class="row">
                  <div class="col-md-2"></div>
                  <div class="col-md-4">
                    <h4> Serial Number </h4>
                  </div>
                  <div class="col-md-1">:</div>
                  <div class="col-md-4">
                    <input type="text" name="serial_number" class="form-control" value="{{ old('serial_number')}}">
                      @error('serial_number')
                        <span style="color:red;"><b>{{ $message }}</b></span>
                      @enderror
                  </div>
                  <div class="col-md-1"></div>
                </div>
                <hr>
                <div class="row">
                  <div class="col-md-2"></div>
                  <div class="col-md-4">
                    <h4> Registration Number </h4>
                  </div>
                  <div class="col-md-1">:</div>
                  <div class="col-md-4">
                    <input type="text" name="registration_number" class="form-control" value="{{ old('registration_number') }}">
                    @error('registration_number')
                        <span style="color:red;"><b>{{ $message }}</b></span>
                      @enderror
                  </div>
                  <div class="col-md-1"></div>
                </div>
                <hr>
                <div class="row">
                  <div class="col-md-5"></div>
                  <div class="col-md-2">
                    <button class="btn btn-lg btn-danger" type="reset" style=" font-weight: bolder;"> Reset </button>
                  </div>
                  <div class="col-md-2">
                    <button type="submit"  id="get_result" class="btn btn-lg btn-success" style=" font-weight: bolder;"> Get Result </button>
                  </div>
                  <div class="col-md-3"></div>
                </div>
                <hr>
                </div>
            </div>
        </form>
        </div>
        <div class="card-header"><img src="{{ asset('assets')}}/footer.jpg" width="100%"></div>
    </div>
    <br><br>
  </div>
@endsection