@extends('layouts.frontend.master')
@section('title')
	Registration | Sohag Computer Training Center
@endsection
@section('content')
  <!-- Page breadcrumb -->
  <section id="mu-page-breadcrumb">
     <div class="container">
       <div class="row">
         <div class="col-md-12">
           <div class="mu-page-breadcrumb-area">
             <h2>Branch Registration</h2>
             <ol class="breadcrumb">
              <li><a href="{{ url('/')}}">Home</a></li>            
              <li class="active">Registration</li>
            </ol>
           </div>
         </div>
       </div>
     </div>
  </section>
  <!-- End breadcrumb -->
  <!-- Start contact  -->
  <section id="mu-contact">
     <div class="container">
       <div class="row">
         <div class="col-md-12">
           <div class="mu-contact-area">
            <!-- @if ($errors->any())
                <div class="alert alert-danger text-center">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif -->
            @if (session('success'))
              <div class="alert alert-warning alert-dismissable custom-success-box" style="margin: 15px;">
                 <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                 <strong> {{ session('success') }} </strong>
              </div>
            @endif
            <!-- start contact content -->
            <div class="mu-contact-content">           
              <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-6">
                  <div class="mu-contact-left">
                    <form class="contactform" method="POST" action="{{ route('branch_register.store') }}" enctype="multipart/form-data">
                      @csrf                
                      <p class="comment-form-author">
                        <label for="branch_name"> Name of Branch <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" value="{{ old('branch_name') }}" name="branch_name">
                        @error('branch_name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>                  
                      <p class="comment-form-author">
                        <label for="branch_code"> Branch Code <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" value="{{ old('branch_code') }}" name="branch_code">
                        @error('branch_code')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>                  
                      <p class="comment-form-author">
                        <label for="chairman_name"> Chairman Name <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" value="{{ old('chairman_name') }}" name="chairman_name">
                        @error('chairman_name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>                   
                      <p class="comment-form-author">
                        <label for="address"> Address <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" value="{{ old('address') }}" name="address">
                        @error('address')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>                    
                      <p class="comment-form-author">
                        <label for="branch_logo"> Branch LOGO  <span class="required" style="color:red;"> * </span> : </label>
                        <input type="file" size="30" value="{{ old('branch_logo') }}" name="branch_logo">
                        @error('branch_logo')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>                     
                      <p class="comment-form-author">
                        <label for="chairman_photo"> Chairman Photo : <span class="required" style="color:red;"> * </span> : </label>
                        <input type="file" size="30" value="{{ old('chairman_photo') }}" name="chairman_photo">
                        @error('chairman_photo')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>                  
                      <p class="comment-form-author">
                        <label for="email"> E-mail/Phone Number <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" value="{{ old('email') }}" name="email">
                        @error('email')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>
                      <p class="comment-form-author">
                        <label for="password"> Password <span class="required" style="color:red;"> * </span> : </label>
                        <input type="password" size="30" value="{{ old('password') }}" name="password">
                        @error('password')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p> 
                      <p class="comment-form-author">
                        <label for="author"> Confirm Password <span class="required" style="color:red;"> * </span> : </label>
                        <input type="password" size="30" name="confirm_password" value="{{ old('confirm_password') }}" >
                        @error('password')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </p>           
                      <p class="form-submit">
                        <button class="mu-post-btn" type="submit"> REGISTRATION </button>
                      </p>        
                    </form>
                  </div>
                </div>
                <div class="col-md-3"></div>
              </div>
            </div>
            <!-- end contact content -->
           </div>
         </div>
       </div>
     </div>
  </section>
  <!-- End contact  -->



@endsection