@extends('layouts.backend.master')
@section('title')
	 - All Result
@endsection
@section('mainPart')
	<main class="ttr-wrapper">
		<div class="container-fluid">
            @if(Session::has('message'))
                <div class="notification"><div class="alert alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ Session::get('message') }}</div></div>
            @endif
			<div class="db-breadcrumb">
				<h4 class="breadcrumb-title">Results</h4>
				<ul class="db-breadcrumb-list">
					<li><a href="{{ route('author.dashboard') }}"><i class="fa fa-home"></i>Home</a></li>
					<li>All Result</li>
				</ul>
			</div>
			<div class="row">
				<div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-12">
                    <table class="table table-hover table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <!-- <th>Branch Name </th> -->
                                <th>Student Name</th>
                                <!-- <th>Course Name</th> -->
                                <!-- <th>Batch</th> -->
                                <th>Registration</th>
                                <th>Serial Number</th>
                                <th>Phone number</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($results as $key =>$result)
                        	<tr>
                                <td>{{ ++$key }}</td>   
                                <!-- <td>{{ $result->branch_name}}</td>   -->
                                <td>{{ $result->student_name}}</td>
                                <!-- <td>{{ $result->course_name}}</td> -->
                                <!-- <td>{{ $result->batch_name}}</td> -->
                                <td>{{ $result->registration_number}}</td>
                                <td>{{ $result->serial_number}}</td>
                                <td>{{ $result->mobile_number}}</td>
                                <td>
                                    @if( $result->status == 0)
                                    <span class="btn btn-sm btn-warning" style="color:green; font-weight: bolder;"> Pending </span>
                                    @elseif( $result->status==1 )
                                    <span class="btn btn-sm btn-success"> Published </span>
                                    @endif
                                <td>
                                    <a href="#" title="view" class="btn btn-sm btn-info" data-toggle="modal" data-target="#viewModal{{ $result->id}}" > View details </i></a>
                                    <a href="#" title="Delete" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $result->id}}" > Delete </i></a>
                                </td>
                            </tr>
                                    <!-- view Modal -->
                                    <div class="modal fade" id="viewModal{{ $result->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-lg" role="document">
                                            <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Branch details</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="col-md-2"></div>
                                                        <div class="col-md-8">
                                                            <div class="row">
                                                                <div class="col-md-4"></div>
                                                                <div class="col-md-4">
                                                                    <h6> <img class="img-thumbnail" src="{{ url('storage/image/'.$result->image)}}"></h6>
                                                                </div>
                                                                <div class="col-md-4"></div>
                                                            </div>
                                                            <hr>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Student Name: </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->student_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Father's Name: </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->father_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Mother's Name : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->mother_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Date Of Birth : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->date_of_birth}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Mobile Number : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->mobile_number}}</h6>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Mobile Number : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->course_code}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Branch Name : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->branch_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Branch Code : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->branch_code}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Branch Address : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->address}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Course Name : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->course_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Registration Number : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->registration_number}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Serial Number : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->serial_number}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Batch Name : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->batch_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Semester : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->semester}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Total Marks : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->total_marks}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Get Marks : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->get_marks}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> CGPA : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->cgpa}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Grade : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $result->grade}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Status : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    @if( $result->status==0 )<span class="btn btn-sm btn-warning" style="color:green; font-weight: bolder;"> Pending </span>
                                                                    @elseif( $result->status==1 )<span class="btn btn-sm btn-success"> Approved </span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2"></div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="deleteModal{{ $result->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Delete?</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form method="post" action="{{ route('admin.result.destroy', $result->id) }}">
                                                @csrf
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="{{ $result->id}}" />
                                                    <center><span class="h3 text-danger">Are you Sure ?</span></center>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger bg-danger">Delete</button>
                                                </div>
                                            </form>
                                            </div>
                                        </div>
                                    </div>
                            @endforeach
                        </tbody>
                    </table>
				</div>
			</div>
		</div>
    </main>
@endsection
