@extends('layouts.backend.master')
@section('title')
     - Result
@endsection
@section('mainPart')
    <main class="ttr-wrapper">
        <div class="container-fluid">
            @if(Session::has('message'))
                <div class="notification"><div class="alert alert-warning alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ Session::get('message') }}</div></div>
            @endif
            @if ($errors->any())
			    <div class="alert alert-danger align-center">
			    	<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			        <ul>
			            @foreach ($errors->all() as $error)
			                <li>{{ $error }}</li>
			            @endforeach
			        </ul>
			    </div>
			@endif
            <div class="db-breadcrumb">
                <h4 class="breadcrumb-title">Add New Result</h4>
                <ul class="db-breadcrumb-list">
                    <li><a href="{{ route('author.dashboard') }}"><i class="fa fa-home"></i>Home</a></li>
                    <li>Add New Result </li>
                </ul>
            </div>
            <form action="{{ route('author.result.store')}}" method="POST"  enctype="multipart/form-data">
            	@csrf
	            <div class="card-header">
	            	<div class="row">
		            	<div class="col-md-6">
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center">Branch Name </label>
		            			</div>		
		            			<div class="col-md-7">
		            				<select class="form-control" name="branches_id" id="branches_id">
		            					<option>Select Branch</option>
		            					@foreach($branchs as $branch)
		            					<!-- <option value="{{ $branch->id }}">{{ $branch->branch_name }}</option> -->
		            					<option value="{{ $branch->id }}" {{ (collect(old('branches_id'))->contains($branch->id)) ? 'selected':'' }}>{{ $branch->branch_name }}</option>
		            					@endforeach
		            				</select>
		            				@error('branches_id')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center">Branch Code :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" readonly name="branch_code" class="form-control branch_code_view" placeholder="Auto Load" value="{{old('branch_code')}}">
		            				@error('branch_code')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Student Name :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="student_name" value="{{old('student_name')}}" class="form-control">
		            				@error('student_name')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Father's Name :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="father_name" class="form-control" value="{{old('father_name')}}">
		            				@error('father_name')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Mother's Name :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="mother_name" class="form-control" value="{{old('mother_name')}}">
		            				@error('mother_name')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Date of Birth :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="date" name="date_of_birth" class="form-control" value="{{old('date_of_birth')}}">
		            				@error('date_of_birth')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Address :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="address" class="form-control" placeholder="Vill:........Post:.......Ps:........Dist:......." value="{{old('address')}}">
		            				@error('address')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            	</div>
		            	<div class="col-md-6">
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center">Phone Number :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="mobile_number" class="form-control" value="{{old('mobile_number')}}">
		            				@error('mobile_number')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Course Name :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<select class="form-control" name="courses_id" id="courses_id">
		            					<option>Select Course</option>
		            					@foreach($courses as $course)
		            					<option value="{{ $course->id }}" {{ (collect(old('courses_id'))->contains($course->id)) ? 'selected':'' }}>{{ $course->name }}</option>
		            					@endforeach
		            				</select>
		            				@error('courses_id')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Course Code :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="course_code" readonly class="form-control courses_code_view" placeholder="Auto Load" value="{{old('course_code')}}">
		            				@error('course_code')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Registration No:</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="registration_number" class="form-control" value="{{ old('registration_number') }}">
		            				@error('registration_number')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Serial Number:</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="serial_number" class="form-control" value="{{ old('serial_number') }}">
		            				@error('serial_number')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Batch :</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<select class="form-control" name="batches_id">
		            					<option> Select Batch </option>
		            					@foreach($batches as $batch)
		            					<option value="{{ $batch->id }}" {{ (collect(old('batches_id'))->contains($batch->id)) ? 'selected':'' }}> {{ $batch->name }} </option>
		            					@endforeach
		            				</select>
		            				@error('batches_id')
			                            <span style="color:red;"><b>{{ $message }}</b></span>
			                        @enderror
		            			</div>		
		            		</div>
		            		<hr>
		            		<div class="row">
		            			<div class="col-md-3">
		            				<label class="pull-center"> Semester:</label>
		            			</div>		
		            			<div class="col-md-7">
		            				<input type="text" name="semester" class="form-control" value="Final" readonly>
		            			</div>		
		            		</div>
		            	</div>
		            </div>
	            </div>
	            <hr>
	            <table class="table table-bordered table-gray text-center">
				  <thead>
				    <tr>
				      <th scope="col">#S.L</th>
				      <th scope="col">Course</th>
				      <th scope="col">Course Code</th>
				      <th scope="col">T. Marks</th>
				      <th scope="col">Get Marks</th>
				      <th scope="col">CGPA</th>
				      <th scope="col">Grade</th>
				    </tr>
				  </thead>
				  <tbody>
				    <tr>
				      <th scope="row">1</th>
				      <td class="courses_name_view"></td>
				      <td class="courses_code_view"></td>
				      <td><input type="number" readonly step="any" name="total_marks" class="courses_marks_view" value="{{ old('total_marks') }}"></td>
				      <td><input type="number" step="any" name="get_marks" id="get_marks" value="{{ old('get_marks') }}"></td>
				      <td><input type="number" step="any" name="cgpa" value="{{ old('cgpa') }}"></td>
				      <td><input type="text" readonly step="any" name="grade" id="Grade" class="Grade" value="{{ old('grade') }}"></td>
				    </tr>
				  </tbody>
				</table>
	    		<hr>
	    		<div class="row">
	    			<div class="col-md-3">
	    				<label class="pull-center"> Upload Image( Image Max Size 5MB ) : </label>
	    			</div>		
	    			<div class="col-md-1">
	    				<i class="fa fa-user btn btn-success"></i>
	    			</div>		
	    			<div class="col-md-6">
	    				<input type="file" name="image" class="form-control" value="{{ old('image') }}">
	    				@error('iamge')
	    				<span style="color:red;"> {{ $message }}</span>
	    				@enderror
	    			</div>		
	    			<div class="col-md-2" style="margin: 0 auto;">
	    				<button class="btn btn-lg btn-success" type="submit"> Submit </button>
	    			</div>		
	    		</div>
	    	</form>
    		<hr><br><br><br><br>
        </div>
    </main>
 @endsection
