@extends('layouts.frontend.master')
@section('title')
	Registration | Sohag Computer Training Center
@endsection
@section('content')
  <!-- Page breadcrumb -->
  <section id="mu-page-breadcrumb">
     <div class="container">
       <div class="row">
         <div class="col-md-12">
           <div class="mu-page-breadcrumb-area">
             <h2> Student Admission Form </h2>
             <ol class="breadcrumb">
              <li><a href="{{ url('/')}}">Home</a></li>            
              <li class="active">Admission</li>
            </ol>
           </div>
         </div>
       </div>
     </div>
  </section>
  <!-- End breadcrumb -->
  <!-- Start contact  -->
  <section id="mu-contact">
     <div class="container">
       <div class="row">
         <div class="col-md-12">
           <div class="mu-contact-area">
            <!-- @if (session('success'))
              <div class="alert alert-warning alert-dismissable custom-success-box" style="margin: 15px;">
                 <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                 <strong> {{ session('success') }} </strong>
              </div>
            @endif -->
            @if(session()->has('message'))
                <div class="alert alert-warning">
                    <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                 <strong>  {{ session()->get('message') }} </strong>
                </div>
            @endif
            <!-- start contact content -->
            <div class="mu-contact-content">           
              <div class="row">
                <div class="col-md-3"></div>
                <div class="col-md-6">
                  <div class="mu-contact-left">
                    <form class="contactform" method="POST" action="{{ route('admission.store') }}">
                      @csrf
                      <p class="comment-form-author">
                        <label for="author"> Course Name : <span class="required" style="color:red;"> * </span> : </label>
                        <select name="courses_id">
                          <option> Select Course</option>
                          @foreach($courses as $course)
                          <option value="{{$course->id}}" {{ (collect(old('courses_id'))->contains($course->id)) ? 'selected':'' }}>{{ $course->name }}</option>
                          @endforeach
                        </select>
                        @error('courses_id')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p> 
                    <form class="contactform">
                      <p class="comment-form-author">
                        <label for="author"> Course Duration : <span class="required" style="color:red;"> * </span> : </label>
                        <select name="course_duration">
                          <option value=""> Select Duration </option>
                          <option value="3 Month" @if (old('course_duration') == "3 Month") {{ 'selected' }} @endif> 3 Month </option>
                          <option value="6 Month" @if (old('course_duration') == "6 Month") {{ 'selected' }} @endif> 6 Month </option>
                          <option value="1 Year" @if (old('course_duration') == "1 Year") {{ 'selected' }} @endif> 1 Year </option>
                        </select>
                        @error('course_duration')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p>                         
                      <p class="comment-form-author">
                        <label for="author"> Student Name <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30"name="student_name" value="{{ old('student_name')}}">
                        @error('student_name')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p>                  
                      <p class="comment-form-author">
                        <label for="author"> Father's Name <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" name="father_name" value="{{ old('father_name')}}">
                        @error('father_name')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p>                  
                      <p class="comment-form-author">
                        <label for="author"> Date Of Birth <span class="required" style="color:red;"> * </span> : </label>
                        <input type="date" size="30" value="{{ old('date_of_birth') }}" name="date_of_birth">
                        @error('date_of_birth')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p>                   
                      <p class="comment-form-author">
                        <label for="author"> Address <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" value="{{ old('address') }}" name="address">
                        @error('address')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p>                    
                      <p class="comment-form-author">
                        <label for="author"> Mobile Number  <span class="required" style="color:red;"> * </span> : </label>
                        <input type="text" size="30" value="{{ old('mobile_number') }}" name="mobile_number">
                        @error('mobile_number')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p>                   
                      <p class="comment-form-author">
                        <label for="author"> Mobile Number  <span class="required" style="color:red;"> * </span> : </label>
                        Male : <input type="radio" size="30" value="male" name="gender"  @if(old('gender')) checked @endif>
                        Female : <input type="radio" size="30" value="female" name="gender"  @if(old('gender')) checked @endif>
                        @error('gender')
                            <span style="color:red;"><b>{{ $message }}</b></span>
                        @enderror
                      </p>       
                      <p class="form-submit">
                        <button type="submit" class="mu-post-btn"> SUBMIT </button>
                      </p>        
                    </form>
                  </div>
                </div>
                <div class="col-md-3"></div>
              </div>
            </div>
            <!-- end contact content -->
           </div>
         </div>
       </div>
     </div>
  </section>
  <!-- End contact  -->



@endsection