@extends('layouts.backend.master')
@section('title')
	 - Dashboard
@endsection

@section('mainPart')
	<main class="ttr-wrapper">
		<div class="container-fluid">
			@if(Session::has('message'))
			    <div class="notification"><div class="alert alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ Session::get('message') }}</div></div>
			@endif
			@if ($errors->any())
			    <div class="alert alert-danger">
			        <ul>
			            @foreach ($errors->all() as $error)
			                <li>{{ $error }}</li>
			            @endforeach
			        </ul>
			    </div>
			@endif	
			<div class="db-breadcrumb">
				<h4 class="breadcrumb-title">Dashboard</h4>
				<ul class="db-breadcrumb-list">
					<li><a href="{{ url('/') }}"><i class="fa fa-home"></i>Home</a></li>
					<li>Dashboard</li>
				</ul>
			</div>
			<!-- Card -->
			<div class="row">
				<div class="col-md-6 col-lg-3 col-xl-3 col-sm-6 col-12">
					<div class="widget-card widget-bg1">					 
						<div class="wc-item">
							<h4 class="wc-title">
								Total Branch
							</h4>
							<span class="wc-des">
								<a href="" style="color:white;"> See All Branch </a>
							</span>
							<span class="wc-stats">
								<span class="counter">{{ $branch }}</span>
							</span>		
							<div class="progress wc-progress">
								<div class="progress-bar" role="progressbar" style="width: 78%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<hr>
							<span class="wc-progress-bx">
								<span class="wc-change" style="color:white !important;">
									<h4 class="wc-title"> Apporved: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $activeBranch }}</span> </h4>
								</span>
								<span class="wc-number ml-auto" style="color:white !important;">
									<h4 class="wc-title"> Pending: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $inactiveBranch }}</span> </h4>
								</span>
							</span>
						</div>				      
					</div>
				</div>
				<div class="col-md-6 col-lg-3 col-xl-3 col-sm-6 col-12">
					<div class="widget-card widget-bg3">					 
						<div class="wc-item">
							<h4 class="wc-title">
								Total Course
							</h4>
							<span class="wc-des">
								<a href="#"  style="color:white;">See All Course</a>
							</span>
							<span class="wc-stats">
								<span class="counter">{{ $course }}</span>
							</span>		
							<div class="progress wc-progress">
								<div class="progress-bar" role="progressbar" style="width: 78%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<hr>
							<span class="wc-progress-bx">
								<span class="wc-change" style="color:white !important;">
									<h4 class="wc-title"> Active: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $activeCourse }}</span> </h4>
								</span>
								<span class="wc-number ml-auto" style="color:white !important;">
									<h4 class="wc-title"> Inactive: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $inactiveCourse }}</span> </h4>
								</span>
							</span>
							<!-- <span class="wc-progress-bx">
								<span class="wc-change">
									Active: {{ $activeCourse }}
								</span>
								<span class="wc-number ml-auto">
									Inactive: {{ $inactiveCourse }}
								</span>
							</span> -->
						</div>				      
					</div>
				</div>
				<div class="col-md-6 col-lg-3 col-xl-3 col-sm-6 col-12">
					<div class="widget-card widget-bg2">					 
						<div class="wc-item">
							<h4 class="wc-title">
								Total Batch
							</h4>
							<span class="wc-des">
								See All Batch
							</span>
							<span class="wc-stats">
								<span class="counter">{{ $batch }}</span>
							</span>		
							<div class="progress wc-progress">
								<div class="progress-bar" role="progressbar" style="width: 78%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<hr>
							<span class="wc-progress-bx">
								<span class="wc-change" style="color:white !important;">
									<h4 class="wc-title"> Acitve: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $activeBatch }}</span> </h4>
								</span>
								<span class="wc-number ml-auto" style="color:white !important;">
									<h4 class="wc-title"> Inactive: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $inactiveBatch }}</span> </h4>
								</span>
							</span>
						</div>				      
					</div>
				</div>
				<div class="col-md-6 col-lg-3 col-xl-3 col-sm-6 col-12">
					<div class="widget-card widget-bg4">					 
						<div class="wc-item">
							<h4 class="wc-title">
								Results
							</h4>
							<span class="wc-des">
								See All Result
							</span>
							<span class="wc-stats">
								<span class="counter">{{ $result }}</span>
							</span>		
							<div class="progress wc-progress">
								<div class="progress-bar" role="progressbar" style="width: 78%;" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<hr>
							<span class="wc-progress-bx">
								<span class="wc-change" style="color:white !important;">
									<h4 class="wc-title"> Apporved: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $pendingResult }}</span> </h4>
								</span>
								<span class="wc-number ml-auto" style="color:white !important;">
									<h4 class="wc-title"> Pending: &nbsp;&nbsp;&nbsp;<span class="counter">{{ $approvedResult }}</span> </h4>
								</span>
							</span>
						</div>				      
					</div>
				</div>
			</div>
			<!-- Card END -->
		</div>
	</main>
@endsection