@extends('layouts.backend.master')
@section('title')
	 - All Application
@endsection
@section('mainPart')
	<main class="ttr-wrapper">
		<div class="container-fluid">
            @if(Session::has('message'))
                <div class="notification"><div class="alert alert-success alert-dismissible" role="alert"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ Session::get('message') }}</div></div>
            @endif
			<div class="db-breadcrumb">
				<h4 class="breadcrumb-title">Students Application</h4>
				<ul class="db-breadcrumb-list">
					<li><a href="{{ route('admin.dashboard') }}"><i class="fa fa-home"></i>Home</a></li>
					<li>All Application</li>
				</ul>
			</div>
			<div class="row">
				<div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-12">
                    <table class="table table-hover table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Course Name </th>
                                <th>Student Name</th>
                                <th>Phone Number</th>
                                <th>Gender</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($admissions as $key =>$admission)
                        	<tr>
                                <td>{{ ++$key }}</td>   
                                <td>{{ $admission->course_name }}</td>
                                <td>{{ $admission->student_name }}</td>
                                <td>{{ $admission->mobile_number }}</td>
                                <td>{{ $admission->gender }}</td>
                                <td>
                                    @if( $admission->status == 0)
                                    <span class="btn btn-sm btn-warning" style="color:green; font-weight: bolder;"> Pending </span>
                                    @elseif( $admission->status==1 )
                                    <span class="btn btn-sm btn-success"> Published </span>
                                    @endif
                                <td>
                                    @if( $admission->status == 0)<a href="#" class="btn btn-sm btn-success" data-toggle="modal" data-target="#approveModal{{ $admission->id}}" class="mr-2" title="Approve!"> Publish </a>
                                    @endif
                                    <a href="#" title="view" class="btn btn-sm btn-info" data-toggle="modal" data-target="#viewModal{{ $admission->id}}" > View details </i></a>
                                    <a href="#" title="Delete" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $admission->id}}" > Delete </i></a>
                                </td>
                            </tr>

                            <!-- Approve Modal -->
                                <div class="modal fade" id="approveModal{{ $admission->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                            <div class="modal-header">
                                                <h3 class="modal-title" id="exampleModalLabel" style="color:red;">Are you want to Approve this ???</h3>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form method="post" action="{{ route('admin.admission.approve', $admission->id) }}">
                                                @csrf
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="{{ $admission->id}}" />
                                                    <center><span class="h6 text-danger">Are you want to Approve this ???</span></center>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal">No!</button>
                                                    <button type="submit" class="btn btn-success">Yes! Approved</button>
                                                </div>
                                            </form>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- view Modal -->
                                    <div class="modal fade" id="viewModal{{ $admission->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-lg" role="document">
                                            <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">{{ $admission->student_name }}'s Application Information</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                                <div class="modal-body">
                                                    <div class="row">
                                                        <div class="col-md-2"></div>
                                                        <div class="col-md-8">
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Student Name: </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $admission->student_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Father's Name: </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $admission->father_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Date Of Birth : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $admission->date_of_birth}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Mobile Number : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $admission->mobile_number}}</h6>
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Course Name : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $admission->course_name}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Course Duration: </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $admission->course_duration}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Gender : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <!-- @if($admission->gender == "male")
                                                                    <h6> Male </h6>
                                                                    @elseif($admission->gender == "female")
                                                                    <h6> Female</h6>
                                                                    @endif -->
                                                                    @if ($admission->gender == "male")
                                                                        <h6> Male </h6>
                                                                    @elseif ($admission->gender == 'female')
                                                                        <h6> Female </h6>
                                                                    @else
                                                                        <h6> Gender Not Found </h6>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Address : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <h6> {{ $admission->address}}</h6>
                                                                </div>
                                                            </div>
                                                            <div class="row">
                                                                <div class="col-md-6">
                                                                    <h5> Status : </h5>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    @if( $admission->status==0 )<span class="btn btn-sm btn-warning" style="color:green; font-weight: bolder;"> Pending </span>
                                                                    @elseif( $admission->status==1 )<span class="btn btn-sm btn-success"> Approved </span>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-2"></div>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Delete Modal -->
                                    <div class="modal fade" id="deleteModal{{ $admission->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Delete?</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <form method="post" action="{{ route('admin.admission.destroy', $admission->id) }}">
                                                @csrf
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="{{ $admission->id}}" />
                                                    <center><span class="h3 text-danger">Are you Sure ?</span></center>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-danger bg-danger">Delete</button>
                                                </div>
                                            </form>
                                            </div>
                                        </div>
                                    </div>
                            @endforeach
                        </tbody>
                    </table>
				</div>
			</div>
		</div>
    </main>
@endsection
