<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('role_id')->default(2);
            $table->string('chairman_name', 255);
            $table->string('branch_name', 255);
            $table->string('branch_code', 255);
            $table->string('address', 255);
            $table->string('branch_logo', 255)->default('default_logo.png');
            $table->string('chairman_photo', 255)->default('default_photo.png');
            $table->string('email', 150)->unique();
            $table->string('password', 150);
            $table->tinyInteger('status')->default(0);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
