<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

use App\Course;

class ResultPublishController extends Controller
{
    public function  index()
    {
    	$courses = Course::where('status', 1)->get();
    	return view('result_publish',[
    		'courses' => $courses,
    	]);
    }
    public function  store(Request $request)
    {
    	$validator = Validator::make($request->all(),[
    		'courses_id' => 'required|numeric',
    		'serial_number' => 'required',
    		'registration_number' => 'required',
    	]);

    	if ($validator->fails()) 
    	{
    		return redirect()->back()->withErrors($validator)->withInput();
    	}
    	$courses_id = $request->courses_id; 
        $serial_number = $request->serial_number; 
        $registration_number = $request->registration_number;

        $resultS = DB::table('results')
                               ->join('users', 'results.users_id', '=', 'users.id')
                               ->join('batches', 'results.batches_id', '=', 'batches.id')
                               ->join('courses', 'results.courses_id', '=', 'courses.id')
                               ->select('results.*', 'users.branch_name as branch_name', 'batches.name as batch_name', 'courses.name as course_name')
                                ->where('courses_id', $courses_id)
                                ->where('serial_number', $serial_number)
                                ->where('registration_number', $registration_number)
                                ->where('results.status', '1')
                                ->get();
        return view('result_info', ['resultS' => $resultS]);
    }
}
