<?php

namespace App\Http\Controllers\Author;

use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\User;

class BranchRegisterController extends Controller
{
	public function store(Request $request)
	{
		$validator = Validator::make($request->all(),[
		    'branch_name' => 'required|max:255',
		    'branch_code' => 'required|unique:users|max:255',
		    'chairman_name' => 'required|max:255',
		    'address' => 'required|max:255',
		    'branch_logo' => 'required|image|mimes:jpeg,jpg,png,gif|max:10000|max:255',
		    'chairman_photo' => 'required|image|mimes:jpeg,jpg,png,gif|max:10000|max:255',
		    'email' => 'required|unique:users|max:255',
		    'password' => 'min:6|required_with:confirm_password|same:confirm_password|max:255',
		    'confirm_password' => 'min:6|max:255',
		]);
		if ($validator->fails()) {
            return redirect()->back()
                        ->withErrors($validator)
                        ->withInput();
        }
		if ($validator->passes()) {

	        if ($request->hasFile('branch_logo')) {
				  	$branchImage = $request->file('branch_logo');
				  	$branchFilename = 'branch_logo' . '-' . date('m-d-Y') . rand(1000, 99999) . '.' . $branchImage->getClientOriginalExtension();
				  	$location = public_path( 'uploads/branch_logo/' . $branchFilename );
                    Image::make( $branchImage )->resize( 800, 400 )->save( $location );
				//   	$branch_logo = Image::make($branchImage)->resize(211,57)->stream();
				//   	Storage::disk('public')->put('branch_logo/'.$branchFilename, $branch_logo);
				}else {
	            $branchFilename = "default_logo.png";
	        }
	        if ($request->hasFile('chairman_photo')) {
				  	$chairmanImage = $request->file('chairman_photo');
				  	$chairmanFilename = 'chairman_photo' . '-' . date('m-d-Y') . rand(1000, 99999) . '.' . $chairmanImage->getClientOriginalExtension();
				  	$location = public_path( 'uploads/chairman_photo/' . $chairmanFilename );
                    Image::make( $chairmanImage )->resize( 800, 400 )->save( $location );
				//   	$chairman_photo = Image::make($chairmanImage)->resize(500,479)->stream();
				//   	Storage::disk('public')->put('chairman_photo/'.$chairmanFilename, $chairman_photo);
				}else {
	            $chairmanFilename = "default_photo.png";
	        }

	        $user = new User;
	        $user->role_id = 2;
	        $user->chairman_name = $request->chairman_name;
	        $user->branch_name = $request->branch_name;
	        $user->branch_code = $request->branch_code;
	        $user->address = $request->address;
	        $user->branch_logo = $branchFilename;
	        $user->chairman_photo = $chairmanFilename;
	        $user->email = $request->email;
	        $user->password = Hash::make($request->confirm_password);
	        //$user->password = bcrypt($request->confirm_password);
	        $user->save();
	        return redirect()->back()->with('success', 'Registration successfully completed.You need approval to Login!');
        }

	}
}
