<?php

namespace App\Http\Controllers\Author;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Facades\Image;
use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\User;

class BranchController extends Controller
{

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'branch_name' => 'required|max:255',
            'branch_code' => 'required|max:255',
            'chairman_name' => 'required|max:255',
            'address' => 'required|max:255',
            'branch_logo' => 'image|mimes:jpeg,jpg,png,gif|max:10000|max:255',
            'chairman_photo' => 'image|mimes:jpeg,jpg,png,gif|max:10000|max:255',
            'email' => 'required|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $branch_logo = $request->file('branch_logo');
        $chairman_photo = $request->file('chairman_photo');
        $data = User::find($request->id);

        if (isset($branch_logo)) 
        {
            $currentDate = Carbon::now()->toDateString();
            $branchImageName = "branch_logo".'-'.$currentDate.'-'.uniqid().'.'.$branch_logo->getClientOriginalExtension();
            if (!Storage::disk('public')->exists('branch_logo')) 
            {
                Storage::disk('public')->delete('branch_logo');
            }
            $branch_logo = Image::make($branch_logo)->resize(211,57)->stream();
            Storage::disk('public')->put('branch_logo/'.$branchImageName, $branch_logo);
        }else {
            $branchImageName = $data->branch_logo;
        }

        if (isset($chairman_photo)) 
        {
            $currentDate = Carbon::now()->toDateString();
            $chirmanImageName = "chairman_photo".'-'.$currentDate.'-'.uniqid().'.'.$chairman_photo->getClientOriginalExtension();
            if (!Storage::disk('public')->exists('chairman_photo')) 
            {
                Storage::disk('public')->delete('chairman_photo');
            }
            $chairman_photo = Image::make($chairman_photo)->resize(500,479)->stream();
            Storage::disk('public')->put('chairman_photo/'.$chirmanImageName, $chairman_photo);
        }else {
            $chirmanImageName = $data->chairman_photo;
        }
        
        $data->branch_name = $request->branch_name;
        $data->branch_code = $request->branch_code;
        $data->chairman_name = $request->chairman_name;
        $data->address = $request->address;
        $data->branch_logo = $branchImageName;
        $data->chairman_photo = $chirmanImageName;
        $data->email = $request->email;
        $data->save();
        return redirect()->back()->with('message','Profile Information Update Successfully!');
    }

    public function passwordUpdate(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'old_password' => 'required|max:255',
            'new_password' => 'min:6|required_with:confirm_new_password|same:confirm_new_password',
            'confirm_new_password' => 'min:6'
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
            $user = User::findOrFail($request->id);

             if (Hash::check($request->old_password, $user->password) && $request->email === $user->email) 
            { 
                $user->fill([
                    'password' => Hash::make($request->confirm_new_password)
                ])->save();
                return redirect()->back()->with('message','You has been changed Successfully!');
            }
    }
}

