<?php

namespace App\Http\Controllers\Author;

use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Batch;

class BatchController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $batches = Batch::all();
        return view('author.batch', ['batches' => $batches]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'name' => 'required|max:255|unique:batches',
            'status' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $batch = new Batch();
        $batch->name = $request->name;
        $batch->status = $request->status;
        $batch->save();
        return redirect()->back()->with('message','New Batch Created Successfully!');
    }

    public function status(Request $request)
    {
        $batch = Batch::find($request->id);
        if ($batch->status == 1) {
            $status = 0;
        }else{
            $status = 1;
        }
        $batch->status = $status;
        $batch->save();
        return redirect()->back()->with('message','Batch Status Changed Successfully!');
    }

    public function update(Request $request)
    {
        $batch = Batch::find($request->id);
        $batch->name = $request->name;
        $batch->status = $request->status;
        $batch->save();
        return redirect()->back()->with('message','Batch Updated Successfully!');
    }

    public function destroy(Request $request)
    {
        $batch = Batch::find($request->id);
        $batch->delete();
        return redirect()->back()->with('message','Batch Deleted Successfully!');
    }
}
