<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Admission;
use App\Course;

class AdmissionController extends Controller
{
    public function index()
    {
    	$courses = Course::where('status', 1)->get();
    	return view('admission', [
    		'courses' => $courses,
    	]);
    }    

    public function store(Request $request)
    {
    	$validator = Validator::make($request->all(),[
    		'courses_id' => 'required|numeric',
    		'course_duration' => 'required|max:50',
    		'student_name' => 'required|max:100',
    		'father_name' => 'required|max:100',
    		'date_of_birth' => 'required',
    		'address' => 'required|max:150',
    		'mobile_number' => 'required|numeric|unique:admissions',
    		'gender' => 'required|max:20',
    	]);
    	if ($validator->fails()) 
    	{
    		return redirect()->back()->withErrors($validator)->withInput();
    	}

    	$admission = new Admission;
    	$admission->courses_id = $request->courses_id;
    	$admission->course_duration = $request->course_duration;
    	$admission->student_name = $request->student_name;
    	$admission->father_name = $request->father_name;
    	$admission->date_of_birth = $request->date_of_birth;
    	$admission->address = $request->address;
    	$admission->mobile_number = $request->mobile_number;
    	$admission->gender = $request->gender;
    	$admission->status = 0;
    	$admission->save();
    	return redirect()->back()->with('message', 'Pending! Admission Successfully Registed You Need To Pending Approval');
    }

}
