<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Facades\Image;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Result;
use App\Course;
use App\Batch;
use App\User;
use File;

class ResultController extends Controller
{
    public function index()
  	{
	   	$batches = Batch::where('status', 1)->get();
	   	$courses = Course::where('status', 1)->get();
	   	$branchs = User::all();

	   	return view('admin.add_result', [
	   		'batches' => $batches, 
	   		'courses' => $courses, 
	   		'branchs' => $branchs
	   	]);
   	}

	public function branches_id(Request $request)
   	{
      $data = User::find($request);
      return response()->json($data);
   	} 

	public function courses_id(Request $request)
   	{
      $data = Course::find($request);
      return response()->json($data);
   	}

  	public function store(Request $request)
   	{
   		$validator = Validator::make($request->all(),[
   			'branches_id' => 'required|numeric',
   			'branch_code' => 'required|max:255',
   			'student_name' => 'required|max:255',
   			'father_name' => 'required|max:255',
   			'mother_name' => 'required|max:255',
   			'date_of_birth' => 'required',
   			'address' => 'required|max:255',
   			'mobile_number' => 'required|numeric|unique:results',
   			'courses_id' => 'required|numeric',
   			'course_code' => 'required|max:255',
   			'registration_number' => 'required|max:255|unique:results',
   			'serial_number' => 'required|max:255|unique:results',
   			'batches_id' => 'required|numeric',
   			'semester' => 'required',
   			'total_marks' => 'required|numeric',
   			'get_marks' => 'required',
   			'cgpa' => 'required',
   			'grade' => 'required',
   			'image' => 'required|image|mimes:jpeg,jpg,png,gif|max:10000|max:255',
   		]);

   		if ($validator->fails()) {
           	return redirect()->back()->withErrors($validator)->withInput();
        }

      	if ($request->hasFile('image')) 
      	{
          $image = $request->file('image');
          	if (isset($image))
          	{
              $currentDate = Carbon::now()->toDateString();
              $imageName = 'student-'.'-'.$currentDate.'-'.uniqid().'.'.$image->getClientOriginalExtension();
              $location = public_path( 'uploads/student_image/' . $imageName );
              Image::make( $image )->resize( 150, 150 )->save( $location );
            //   if (!Storage::disk('public')->exists('image'))
            //   {
            //       Storage::disk('public')->makeDirectory('image');
            //   }
            //   $imagePath = Image::make($image)->resize(150,150)->stream();
            //   Storage::disk('public')->put('image/'.$imageName,$imagePath);
          	} else {
              $imageName = "default_student_img.png";
          	}
          	$data = new Result();
          	$data->users_id = $request->branches_id;
          	$data->branch_code = $request->branch_code;
          	$data->student_name = $request->student_name;
          	$data->father_name = $request->father_name;
          	$data->mother_name = $request->mother_name;
          	$data->date_of_birth = $request->date_of_birth;
          	$data->address = $request->address;
          	$data->mobile_number = $request->mobile_number;
          	$data->courses_id = $request->courses_id;
          	$data->course_code = $request->course_code;
          	$data->registration_number = $request->registration_number;
          	$data->serial_number = $request->serial_number;
          	$data->batches_id = $request->batches_id;
          	$data->semester = $request->semester;
          	$data->total_marks = $request->total_marks;
          	$data->get_marks = $request->get_marks;
          	$data->cgpa = $request->cgpa;
          	$data->grade = $request->grade;
          	$data->image = $imageName;
          	$data->status = 0;
          	$data->save();

	        if($data)
	        {
	            return redirect()->back()->with('message','Succcess!: Waiting for approval!');
	        }
      }
   	}

   	public function show()
   	{
   		$results = DB::table('results')
               ->join('users', 'results.users_id', '=', 'users.id')
               ->join('batches', 'results.batches_id', '=', 'batches.id')
               ->join('courses', 'results.courses_id', '=', 'courses.id')
               ->select('results.*', 'users.branch_name as branch_name', 'batches.name as batch_name', 'courses.name as course_name')
               
               ->paginate(15);
        return view('admin.result_show', [
        	'results' => $results,
        ]);
   	}

   	public function approve(Request $request)
    {
        $data = Result::find($request->id);
        if ($data->status == 1) {
            $status = 0;
        }else{
            $status = 1;
        }
        $data->status = $status;
        $data->save();
        return redirect()->back()->with('message','Result Successfully Approved');
    }
    public function destroy(Request $request)
    {
        $result = Result::find($request->id);
        // if (Storage::disk('public')->exists('image/'.$result->image)) 
        // {
        //     Storage::disk('public')->delete('image/'.$result->image);
        // }
        // if (Storage::disk('public')->exists('image/'.$result->image)) 
        // {
        //     Storage::disk('public')->delete('image/'.$result->image);
        // }
        File::delete( 'public_html/uploads/student_image/' . $result->image );
        $result->delete();
        return redirect()->back()->with('message','Result Deleted Successfully!');
    }
}
