<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Result;
use App\Course;
use App\Batch;
use App\User;

class DashboardController extends Controller
{
    public function index()
    {
    	$branch = User::where('role_id', 2)->get();
    	$activeBranch = User::where('status', 1)->get();
    	$inactiveBranch = User::where('status', 0)->get();

    	$batch = Batch::all();
    	$activeBatch = Batch::where('status', 1)->get();
    	$inactiveBatch = Batch::where('status', 0)->get();

    	$course = Course::all();
    	$activeCourse = Course::where('status', 1)->get();
    	$inactiveCourse = Course::where('status', 0)->get();

    	$result = Result::all();
    	$pendingResult = Result::where('status', 1)->get();
    	$approvedResult = Result::where('status', 0)->get();
    	return view('admin.dashboard', [
    		'branch' => count($branch),
    		'activeBranch' => count($activeBranch),
    		'inactiveBranch' => count($inactiveBranch),
    		'batch' => count($batch),
    		'activeBatch' => count($activeBatch),
    		'inactiveBatch' => count($inactiveBatch),
    		'course' => count($course),
    		'activeCourse' => count($activeCourse),
    		'inactiveCourse' => count($inactiveCourse),
    		'result' => count($result),
    		'pendingResult' => count($pendingResult),
    		'approvedResult' => count($approvedResult),
    	]);
    }

}
