<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Course;

class CourseController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $courses = Course::all();
        return view('admin.courses', ['courses' => $courses]);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'name' => 'required|max:255|unique:courses',
            'code' => 'required|max:255',
            'status' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $course = new Course();
        $course->name = $request->name;
        $course->code = $request->code;
        $course->status = $request->status;
        $course->save();
        return redirect()->back()->with('message','New Course Created Successfully!');
    }

    public function status(Request $request)
    {
        $course = Course::find($request->id);
        if ($course->status == 1) {
            $status = 0;
        }else{
            $status = 1;
        }
        $course->status = $status;
        $course->save();
        return redirect()->back()->with('message','Course Status Changed Successfully!');
    }

    public function update(Request $request, Course $course)
    {
        $course = Course::find($request->id);
        $course->name = $request->name;
        $course->code = $request->code;
        $course->status = $request->status;
        $course->save();
        return redirect()->back()->with('message','Course Updated Successfully!');
    }

    public function destroy(Request $request)
    {
        $course = Course::find($request->id);
        $course->delete();
        return redirect()->back()->with('message','Course Deleted Successfully!');
    }
}
