<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

use App\Admission;

class AdmissionController extends Controller
{
    public function index()
    {
    	$admissions = DB::table('admissions')
               ->join('courses', 'admissions.courses_id', '=', 'courses.id')
               ->select('admissions.*', 'courses.name as course_name')
               ->get();
    	return view('admin.admission', [
    		'admissions' => $admissions,
    	]);
    }

    public function approve(Request $request)
    {
    	$admission = Admission::find($request->id);
        if ($admission->status == 1) {
            $status = 0;
        }else{
            $status = 1;
        }
        $admission->status = $status;
        $admission->save();
        return redirect()->back()->with('message','Admission Approved Successfully!');
    }

    public function destroy(Request $request)
    {
        $admission = Admission::find($request->id);
        $admission->delete();
        return redirect()->back()->with('message','Admission Info Deleted Successfully!');
    }
}
